(* ========================================================================= *)
(* THE PLAYERS OF A TWO PLAYER GAME                                          *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Side =
sig

(* ------------------------------------------------------------------------- *)
(* Sides.                                                                    *)
(* ------------------------------------------------------------------------- *)

datatype side = Black | White

val compare : side * side -> order

val equal : side -> side -> bool

val allSides : side list

val isBlack : side -> bool

val isWhite : side -> bool

val opponent : side -> side

(* ------------------------------------------------------------------------- *)
(* Generating random values.                                                 *)
(* ------------------------------------------------------------------------- *)

val random : unit -> side

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty-printing.                                              *)
(* ------------------------------------------------------------------------- *)

val toChar : side -> char

val fromChar : char -> side

val toString : side -> string

val fromString : string -> side

val toLongString : side -> string

val fromLongString : string -> side

val pp : side Print.pp

(* ------------------------------------------------------------------------- *)
(* Storing data for both sides.                                              *)
(* ------------------------------------------------------------------------- *)

type 'a sides = {black : 'a, white : 'a}

val sidesCompare : ('a * 'a -> order) -> 'a sides * 'a sides -> order

val sidesEqual : ('a -> 'a -> bool) -> 'a sides -> 'a sides -> bool

val pickSides : 'a sides -> side -> 'a

val mapSides : ('a -> 'b) -> 'a sides -> 'b sides

val appSides : ('a -> unit) -> 'a sides -> unit

val switchSides : 'a sides -> 'a sides

val normalizeSides : side -> 'a sides -> 'a sides

end
