(* ========================================================================= *)
(* FEN2IMG TESTS                                                             *)
(* Copyright (c) 2004 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

(* ------------------------------------------------------------------------- *)
(* Dummy versions of Moscow ML declarations to stop real compilers barfing.  *)
(* ------------------------------------------------------------------------- *)

(*mlton
val quotation = ref true;
val quietdec  = ref true;
val loadPath  = ref ([] : string list);
val load = fn (_ : string) => ();
*)

(*polyml
val quotation = ref true;
val quietdec  = ref true;
val loadPath  = ref ([] : string list);
val load = fn (_ : string) => ();
*)

(* ------------------------------------------------------------------------- *)
(* Load and open some useful modules.                                        *)
(* ------------------------------------------------------------------------- *)

val () = loadPath := !loadPath @ ["../bin/mosml"];
val () = app load ["Options"];

open Useful;

val time = Portable.time;

(* ------------------------------------------------------------------------- *)
(* Helper functions.                                                         *)
(* ------------------------------------------------------------------------- *)

fun SAY s =
    TextIO.print
      ("-------------------------------------" ^
       "-------------------------------------\n" ^ s ^ "\n\n");

fun printval p x = (TextIO.print (Print.toString p x ^ "\n\n"); x);

(* ------------------------------------------------------------------------- *)
val () = SAY "Creating chess diagrams";
(* ------------------------------------------------------------------------- *)

val () = Chess.IMAGE_PATH := "../data/images";

fun mk_diagram s =
    let
      val () = TextIO.print (s ^ "\n")

      val fen = Stream.fromTextFile {filename = s ^ ".fen"}

      val fen = chomp (String.concat (Stream.toList fen))

      val diagram = Chess.fen_prefix_to_diagram fen
    in
      Chess.diagram_to_image diagram
    end;

val example_image = time mk_diagram "example";

val () =
    time Image.toPlainPpm
      {filename = "example.ppm",
       image = example_image,
       background = Image.white};

val logo_image =
    let
      val i = time mk_diagram "logo"
      val i = Image.chopVertical {top = 5 + 48, size = 7 * 48} i
      val i = Image.chopHorizontal {left = 5, size = 7 * 48} i
    in
      i
    end;

val () =
    time Image.toPlainPpm
      {filename = "logo.ppm",
       image = logo_image,
       background = Image.white};

(* ------------------------------------------------------------------------- *)
val () = SAY "PGN format";
(* ------------------------------------------------------------------------- *)

fun read_pgn s =
    let
      val games = Chess.pgn_to_games {filename = s ^ ".pgn"}
      val pgn = Chess.game_to_pgn (hd games)
(* Too expensive
      val () = Chess.pgn_to_html {path = ".", basename = s}
*)
    in
      TextIO.print (pgn ^ "\n")
    end;

val () = app (time read_pgn) ["example"];
