(* ========================================================================= *)
(* GO BOARDS                                                                 *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Board =
sig

(* ------------------------------------------------------------------------- *)
(* A type of go boards.                                                      *)
(* ------------------------------------------------------------------------- *)

type board

val empty : Dimensions.dimensions -> board

val compare : board * board -> order

val equal : board -> board -> bool

val switchSides : board -> board

val tabulate :
    Dimensions.dimensions -> (Point.point -> Side.side option) -> board

(* ------------------------------------------------------------------------- *)
(* Geometry.                                                                 *)
(* ------------------------------------------------------------------------- *)

val dimensions : board -> Dimensions.dimensions

val points : board -> PointSet.set

val neighbours : board -> Point.point -> PointSet.set

val transform : Symmetry.symmetry -> board -> board

(* ------------------------------------------------------------------------- *)
(* Blocks of connected stones.                                               *)
(* ------------------------------------------------------------------------- *)

type block

val blockStones : block -> PointSet.set

val blockNeighbours : block -> PointSet.set

val liberties : block -> PointSet.set

val countLiberties : block -> int

val atari : block -> bool

(* ------------------------------------------------------------------------- *)
(* Examining the stones on the board.                                        *)
(* ------------------------------------------------------------------------- *)

val emptyPoints : board -> PointSet.set

val peek : board -> Point.point -> (Side.side * block) option

val destStone : board -> Point.point -> Side.side option

val isStone : board -> Point.point -> bool

val isEmpty : board -> Point.point -> bool

val countStones : board -> int Side.sides

val countBlocks : board -> int Side.sides

val foldStones : (Point.point * 'a -> 'a) -> 'a -> board -> Side.side -> 'a

val foldBlocks : (block * 'a -> 'a) -> 'a -> board -> Side.side -> 'a

val status : board -> Point.point -> Status.status

(* ------------------------------------------------------------------------- *)
(* Altering the stones on the board.                                         *)
(* ------------------------------------------------------------------------- *)

val placeStone :
    {permitSuicide : bool} -> board -> Side.side -> Point.point -> board

val clearPoints : board -> PointSet.set -> board

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : board Print.pp

val toString : board -> string

end
