(* ========================================================================= *)
(* GO BOARD DIMENSIONS                                                       *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Dimensions =
sig

(* ------------------------------------------------------------------------- *)
(* Go board dimensions.                                                      *)
(* ------------------------------------------------------------------------- *)

type dimensions = {files : int, ranks : int}

val default : dimensions

val files : dimensions -> int

val ranks : dimensions -> int

val numPoints : dimensions -> int

val member : Point.point -> dimensions -> bool

val points : dimensions -> PointSet.set

val map : (Point.point -> 'a) -> dimensions -> 'a PointMap.map

val fold : (Point.point * 'a -> 'a) -> 'a -> dimensions -> 'a

val app : (Point.point -> unit) -> dimensions -> unit

(* ------------------------------------------------------------------------- *)
(* Square boards.                                                            *)
(* ------------------------------------------------------------------------- *)

val mkSquare : int -> dimensions

val destSquare : dimensions -> int option

val isSquare : dimensions -> bool

(* ------------------------------------------------------------------------- *)
(* Neighbouring points.                                                      *)
(* ------------------------------------------------------------------------- *)

val neighbours : dimensions -> Point.point -> PointSet.set

val foldNeighbours :
    (Point.point * 'a -> 'a) -> 'a -> dimensions -> Point.point -> 'a

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : dimensions Print.pp

val toString : dimensions -> string

end
