(* ========================================================================= *)
(* THE GO PLAYING ENGINE                                                     *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Engine =
sig

(* ------------------------------------------------------------------------- *)
(* A type of go engines.                                                     *)
(* ------------------------------------------------------------------------- *)

type engine

val new :
    {name : string,
     version : string,
     position : Position.position} -> engine

val position : engine -> Position.position

val database : engine -> Database.database

(* ------------------------------------------------------------------------- *)
(* Go text protocol operations.                                              *)
(* ------------------------------------------------------------------------- *)

val boardsize : engine -> int -> engine

val clearBoard : engine -> engine

val finalScore : engine -> Score.score

val generateMove : engine -> Side.side -> Move.move * engine

val komi : engine -> Komi.komi -> engine

val name : engine -> string

val play : engine -> Side.side -> Move.move -> engine

val quit : engine -> unit

val version : engine -> string

end
