(* ========================================================================= *)
(* GNU TEXT PROTOCOL                                                         *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature GTP =
sig

(* ------------------------------------------------------------------------- *)
(* A type of GTP engines.                                                    *)
(* ------------------------------------------------------------------------- *)

type gtp

val initial :
    {name : string,
     version : string,
     rules : Rules.rules,
     komi : Komi.komi,
     boardsize : int} -> gtp

val command : gtp -> string -> string * gtp option

val loop : {input : TextIO.instream, output : TextIO.outstream} -> gtp -> unit

end
