(* ========================================================================= *)
(* GO GAMES                                                                  *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Game =
sig

(* ------------------------------------------------------------------------- *)
(* A type of Go games.                                                       *)
(* ------------------------------------------------------------------------- *)

type game

val new : unit -> game

val position : game -> Position.position

val history : game -> (Position.move * Position.move) list

val toMove : game -> Side.side

val moves : game -> Position.move list

(* ------------------------------------------------------------------------- *)
(* Tags.                                                                     *)
(* ------------------------------------------------------------------------- *)

type tag = {name : string, value : string}

val tags : game -> tag list

val tag : game -> string -> string option

val insertTag : game -> tag -> game

(* ------------------------------------------------------------------------- *)
(* Scoring.                                                                  *)
(* ------------------------------------------------------------------------- *)

val score : game -> real

end
