(* ========================================================================= *)
(* THE SMART GAME FILE FORMAT (SGF v4) FOR THE GAME OF GO                    *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature GoSgf =
sig

(* ------------------------------------------------------------------------- *)
(* Go SGF types.                                                             *)
(* ------------------------------------------------------------------------- *)

type point = Point.point

type move = Move.move

type stone = Point.point

type properties = (point,move,stone) Sgf.properties

type node = (point,move,stone) Sgf.node

type game = (point,move,stone) Sgf.game

type collection = (point,move,stone) Sgf.collection

(* ------------------------------------------------------------------------- *)
(* SGF properties.                                                           *)
(* ------------------------------------------------------------------------- *)

val MOVE_PROPERTIES : Sgf.propertyIdentifier list

val SETUP_PROPERTIES : Sgf.propertyIdentifier list

val sgfDimensions : int * int -> Dimensions.dimensions

val sgfPoint : Dimensions.dimensions -> point -> point

val sgfMove : Dimensions.dimensions -> move -> move

val sgfPointRectangle :
    Dimensions.dimensions -> point * point -> PointSet.set

val sgfPointList :
    Dimensions.dimensions -> (point * point) list -> PointSet.set

val peekAB : Dimensions.dimensions -> properties -> PointSet.set option

val peekAE : Dimensions.dimensions -> properties -> PointSet.set option

val peekAW : Dimensions.dimensions -> properties -> PointSet.set option

val peekB : Dimensions.dimensions -> properties -> move option

val peekPL : properties -> Side.side option

val peekSZ : properties -> Dimensions.dimensions option

val peekW : Dimensions.dimensions -> properties -> move option

(* ------------------------------------------------------------------------- *)
(* Pretty-printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val ppPoint : point Print.pp

val ppMove : move Print.pp

val ppStone : stone Print.pp

(* ------------------------------------------------------------------------- *)
(* Parsing.                                                                  *)
(* ------------------------------------------------------------------------- *)

type propertyParser = (point,move,stone) Sgf.propertyParser

val pointParser : point Sgf.parser

val moveParser : move Sgf.parser

val stoneParser : stone Sgf.parser

val propertyParser : propertyParser

(* ------------------------------------------------------------------------- *)
(* Reading from a file.                                                      *)
(* ------------------------------------------------------------------------- *)

val read : {filename : string} -> collection

(* ------------------------------------------------------------------------- *)
(* Writing to a file.                                                        *)
(* ------------------------------------------------------------------------- *)

val write : {collection : collection, filename : string} -> unit

end
