(* ========================================================================= *)
(* IMPERATIVE TERMINAL GO POSITIONS                                          *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IConfiguration =
sig

(* ------------------------------------------------------------------------- *)
(* A type of terminal go positions.                                          *)
(* ------------------------------------------------------------------------- *)

type configuration

val new : IBoard.board -> configuration

val load : configuration -> unit  (* Warning: trashes the board *)

val toBoard : configuration -> Board.board

(* ------------------------------------------------------------------------- *)
(* Primitive O(1) queries.                                                   *)
(* ------------------------------------------------------------------------- *)

val status : configuration -> IPoint.point -> Status.status

val pointsScore : configuration -> int

val pointsGroup : configuration -> IPoint.point -> int

val connectedGroup : configuration -> IPoint.point -> IPoint.point -> bool

val sekiGroup : configuration -> IPoint.point -> bool

(* ------------------------------------------------------------------------- *)
(* Interpreting formulas.                                                    *)
(* ------------------------------------------------------------------------- *)

val interpretInteger : configuration -> Formula.integer -> int

val interpretStatus : configuration -> Formula.status -> Status.status

val interpretSide : configuration -> Formula.side -> Side.side option

val interpret : configuration -> Formula.formula -> bool

end
