(* ========================================================================= *)
(* IMPERATIVE FORMULA PROBABILITY INFERENCE                                  *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IInference =
sig

(* ------------------------------------------------------------------------- *)
(* Imperative formula probability inference.                                 *)
(* ------------------------------------------------------------------------- *)

type inference

val new : unit -> inference

val size : inference -> int

val estimate : inference -> Database.estimate

val setEstimate : inference -> Database.estimate -> unit

(* ------------------------------------------------------------------------- *)
(* Inferring formula probabilities (from the estimates).                     *)
(* ------------------------------------------------------------------------- *)

val inferred : inference -> Formula.formula -> Probability.probability

(* ------------------------------------------------------------------------- *)
(* The effect of updating the estimates on the inferred probabilities.       *)
(* ------------------------------------------------------------------------- *)

val updateEstimate : inference -> Database.estimateUpdate -> unit

val inferredAfter :
    inference -> Database.estimateUpdate ->
    Formula.formula -> Probability.probability

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : inference Print.pp

val toString : inference -> string

end
