(* ========================================================================= *)
(* IMPERATIVE PROBABILITY DISTRIBUTIONS OVER INTEGERS                        *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IIntDist =
sig

(* ------------------------------------------------------------------------- *)
(* A type of imperative probability distributions over integers.             *)
(* ------------------------------------------------------------------------- *)

type distribution

val zero : int -> distribution  (* n |-> zero distribution over [0,n) *)

val uniform : int -> distribution  (* n |-> uniform distribution over [0,n) *)

val tabulate : int -> (int -> real) -> distribution

val size : distribution -> int

val totalWeight : distribution -> real

val weight : distribution -> int -> real

val probability : distribution -> int -> real

val setWeight : distribution -> int -> real -> unit

val setWeights : distribution -> (int -> real) -> unit

val sample : distribution -> int

val clone : distribution -> distribution

val copy : distribution -> distribution -> unit

val foldl : (int * real * 's -> 's) -> 's -> distribution -> 's

val foldr : (int * real * 's -> 's) -> 's -> distribution -> 's

val toList : distribution -> (int * real) list

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : int Print.pp -> distribution Print.pp

val toString : distribution -> string

end
