(* ========================================================================= *)
(* IMPERATIVE INTEGER SETS WITH CONSTANT TIME ADD AND RANDOM DELETE          *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IIntSet =
sig

(* ------------------------------------------------------------------------- *)
(* A type of imperative integer sets.                                        *)
(* ------------------------------------------------------------------------- *)

type set

val empty : int -> set  (* argument n defines possible range to be [0,n) *)

val size : set -> int

val member : int -> set -> bool

val clone : set -> set

val copy : set -> set -> unit

val fold : (int * 's -> 's) -> 's -> set -> 's

val app : (int -> unit) -> set -> unit

val add : set -> int -> unit

val delete : set -> int -> unit

val toList : set -> int list

(* ------------------------------------------------------------------------- *)
(* Accessing elements by their index in the set,                             *)
(* where indexes are in the range [0,size).                                  *)
(* ------------------------------------------------------------------------- *)

val sub : set -> int -> int

val swap : set -> int -> int -> unit

(* ------------------------------------------------------------------------- *)
(* Generating random values.                                                 *)
(* ------------------------------------------------------------------------- *)

val random : set -> int

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : int Print.pp -> set Print.pp

val toString : set -> string

end
