(* ========================================================================= *)
(* IMPERATIVE GO KNOWLEDGE                                                   *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IKnowledge =
sig

(* ------------------------------------------------------------------------- *)
(* An imperative type of go knowledge.                                       *)
(* ------------------------------------------------------------------------- *)

type knowledge

val new : Position.position -> knowledge

val position : knowledge -> Position.position

(* ------------------------------------------------------------------------- *)
(* Gaining knowledge through sample games.                                   *)
(* ------------------------------------------------------------------------- *)

val sampleGame : knowledge -> unit

val sampleMoves : knowledge -> Move.move list

val sampleBoard : knowledge -> Board.board

(* ------------------------------------------------------------------------- *)
(* Moves.                                                                    *)
(* ------------------------------------------------------------------------- *)

val playMove : knowledge -> Move.move -> unit

val generateMove : knowledge -> Move.move

(* ------------------------------------------------------------------------- *)
(* Score.                                                                    *)
(* ------------------------------------------------------------------------- *)

val score : knowledge -> Score.score

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : knowledge Parser.pp

val toString : knowledge -> string

end
