(* ========================================================================= *)
(* MOVES ON A FIXED-SIZE BOARD                                               *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IMove =
sig

(* ------------------------------------------------------------------------- *)
(* Moves as integers.                                                        *)
(* ------------------------------------------------------------------------- *)

type move = int

val NO_MOVE : move

val PASS : move

val MOVES : int

val allMoves : move list

val stoneMoves : move list

val mkStoneMove : IPoint.point -> move

val destStoneMove : move -> IPoint.point option

val isStoneMove : move -> bool

val toMove : move -> Move.move

val fromMove : Move.move -> move

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val pp : move Print.pp

val toString : move -> string

end
