(* ========================================================================= *)
(* MOVES ON A FIXED-SIZE BOARD                                               *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

structure IMove :> IMove =
struct

open Useful;

(* ------------------------------------------------------------------------- *)
(* Moves as integers.                                                        *)
(* ------------------------------------------------------------------------- *)

type move = int;

val NO_MOVE = ~1;

val PASS = 0;

(*GomiDebug
val () = if IPoint.isEdge PASS then ()
         else raise Bug "PASS move must be on the edge";
*)

val MOVES = IPoint.POINTS;

val stoneMoves = IPoint.boardPoints;

val allMoves = PASS :: stoneMoves;

fun mkStoneMove (point : IPoint.point) : move = point;

fun destStoneMove (move : move) =
    if move = PASS then NONE
    else
      let
(*GomiDebug
        val () =
            if IPoint.onBoard move then ()
            else raise Bug "IMove.destStoneMove"
*)
      in
        SOME move
      end;

fun isStoneMove move = Option.isSome (destStoneMove move);

fun toMove move =
    if move = PASS then Move.Pass
    else Move.Stone (IPoint.toPoint move);

fun fromMove (Move.Stone pt) = IPoint.fromPoint pt
  | fromMove Move.Pass = PASS;

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val pp = Print.ppMap toMove Move.pp;

val toString = Print.toString pp;

end
