(* ========================================================================= *)
(* IMPERATIVE GO BOARD PATTERNS                                              *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IPattern =
sig

(* ------------------------------------------------------------------------- *)
(* Imperative go board patterns.                                             *)
(* ------------------------------------------------------------------------- *)

type boardInfo =
     {board : IBoard.board,
      toMove : Side.side ref,
      allPatterns : Database.patterns}

type board

val new : boardInfo -> board

val dest : board -> boardInfo

val copy : board -> board -> unit

val clone : board -> board

val updateAllPatterns : board -> Database.patternsUpdate -> unit

val patterns : board -> Database.patterns

val seenPatterns : board -> Database.patterns  (* A subset of allPatterns *)

(* ------------------------------------------------------------------------- *)
(* The effect of playing a move on the board patterns.                       *)
(* ------------------------------------------------------------------------- *)

(* This returns a success result (NONE = impossible or insensible) *)

val patternsAfter : board -> IMove.move -> Database.patternsUpdate option

(* This is assumed to succeed *)

val playMove : board -> IMove.move -> Database.patternsUpdate

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : board Print.pp

val toString : board -> string

end
