(* ========================================================================= *)
(* POINTS ON A FIXED-SIZE BOARD.                                             *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IPoint =
sig

(* ------------------------------------------------------------------------- *)
(* Board dimensions.                                                         *)
(* ------------------------------------------------------------------------- *)

val DIMENSIONS : Dimensions.dimensions

val FILES : int

val RANKS : int

(* ------------------------------------------------------------------------- *)
(* Points as integers.                                                       *)
(* ------------------------------------------------------------------------- *)

type point = int;

val NO_POINT : point

val POINTS : int

val equal : point -> point -> bool

val isEdge : point -> bool

val onBoard : point -> bool

val moveUp : point -> point

val moveDown : point -> point

val moveLeft : point -> point

val moveRight : point -> point

val allPoints : point list

val boardPoints : point list

val fromPoint : Point.point -> point

val toPoint : point -> Point.point

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : point Print.pp

val toString : point -> string

end
