(* ========================================================================= *)
(* IMPERATIVE SAMPLE GAMES                                                   *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature ISample =
sig

(* ------------------------------------------------------------------------- *)
(* An imperative type of game sampler.                                       *)
(* ------------------------------------------------------------------------- *)

type sample

val new : Position.position -> Database.database -> sample

val position : sample -> Position.position

(* ------------------------------------------------------------------------- *)
(* Playing sample games.                                                     *)
(* ------------------------------------------------------------------------- *)

val sample : sample -> Database.database -> Database.database

(* ------------------------------------------------------------------------- *)
(* Examining the state of the last sample game.                              *)
(* ------------------------------------------------------------------------- *)

val moves : sample -> IMove.move IStack.stack

val patterns : sample -> IPattern.board

val configuration : sample -> IConfiguration.configuration

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : sample Print.pp

val toString : sample -> string

end
