(* ========================================================================= *)
(* IMPERATIVE STACKS                                                         *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature IStack =
sig

(* ------------------------------------------------------------------------- *)
(* A type of imperative stacks.                                              *)
(* ------------------------------------------------------------------------- *)

type 'a stack

val empty : {maxSize : int, defaultItem : 'a} -> 'a stack

val size : 'a stack -> int

val isEmpty : 'a stack -> bool

val top : 'a stack -> 'a

val nth : 'a stack -> int -> 'a  (* nth s 0 = top s *)

val push : 'a stack -> 'a -> unit

val pop : 'a stack -> unit

val popN : 'a stack -> int -> unit  (* popN s 1 = pop s *)

val popTop : 'a stack -> 'a

val reset : 'a stack -> unit

val clone : 'a stack -> 'a stack

val copy : 'a stack -> 'a stack -> unit

val foldTopDown : ('a * 's -> 's) -> 's -> 'a stack -> 's

val foldBottomUp : ('a * 's -> 's) -> 's -> 'a stack -> 's

val appTopDown : ('a -> unit) -> 'a stack -> unit

val appBottomUp : ('a -> unit) -> 'a stack -> unit

val all : ('a -> bool) -> 'a stack -> bool

val exists : ('a -> bool) -> 'a stack -> bool

val toList : 'a stack -> 'a list  (* top of stack at head of list *)

(* ------------------------------------------------------------------------- *)
(* Accessing elements by their index in the stack.                           *)
(* Indexes are in the range [0,size), where 0 is the bottom of the stack.    *)
(* ------------------------------------------------------------------------- *)

val sub : 'a stack -> int -> 'a

val update : 'a stack -> int -> 'a -> unit

val duplicate : 'a stack -> int -> int -> unit

val swap : 'a stack -> int -> int -> unit

val remove : 'a stack -> int -> unit  (* swap then pop *)

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : 'a Print.pp -> 'a stack Print.pp

end
