(* ========================================================================= *)
(* GO KOMI                                                                   *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Komi =
sig

(* ------------------------------------------------------------------------- *)
(* A type of go komi.                                                        *)
(* ------------------------------------------------------------------------- *)

type komi = real

val equal : komi -> komi -> bool

val minPointsBlackWin : komi -> int

val maxPointsWhiteWin : komi -> int

val exactPointsDraw : komi -> int option

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val toString : komi -> string

val fromString : string -> komi

end
