(* ========================================================================= *)
(* GO KOMI                                                                   *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

structure Komi :> Komi =
struct

open Useful;

(* ------------------------------------------------------------------------- *)
(* Constants.                                                                *)
(* ------------------------------------------------------------------------- *)

val KOMI_THRESHOLD = 0.05;

(* ------------------------------------------------------------------------- *)
(* A type of go komi.                                                        *)
(* ------------------------------------------------------------------------- *)

type komi = real;

fun equal k1 k2 = Real.abs (k2 - k1) < KOMI_THRESHOLD;

fun minPointsBlackWin komi = Real.ceil (komi + KOMI_THRESHOLD);

fun maxPointsWhiteWin komi = Real.floor (komi - KOMI_THRESHOLD);

fun exactPointsDraw komi =
    let
      val b = minPointsBlackWin komi - 1
      and w = maxPointsWhiteWin komi + 1
    in
      if b = w then SOME b else NONE
    end;

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val toString = Real.fmt (StringCvt.FIX (SOME 1));

fun fromString s =
    case Real.fromString s of
      SOME k => k
    | NONE => raise Error ("Komi.fromString: \"" ^ s ^ "\"");

end
