(* ========================================================================= *)
(* GO MOVES                                                                  *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Move =
sig

(* ------------------------------------------------------------------------- *)
(* A type of go moves.                                                       *)
(* ------------------------------------------------------------------------- *)

datatype move = Stone of Point.point | Pass

val destStone : move -> Point.point option

val isStone : move -> bool

val isPass : move -> bool

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val pp : move Print.pp

val toString : move -> string

val fromString : string -> move

end
