(* ========================================================================= *)
(* GO MOVES                                                                  *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

structure Move :> Move =
struct

open Useful;

(* ------------------------------------------------------------------------- *)
(* A type of go moves.                                                       *)
(* ------------------------------------------------------------------------- *)

datatype move = Stone of Point.point | Pass;

fun destStone (Stone point) = SOME point
  | destStone _ = NONE;

fun isStone move = Option.isSome (destStone move);

fun isPass Pass = true
  | isPass _ = false;

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

fun toString Pass = "pass"
  | toString (Stone point) = Point.toString point;

val pp = Print.ppMap toString Print.ppString;

fun fromString move =
    case String.map Char.toUpper move of
      "PASS" => Pass
    | move => Stone (Point.fromString move);

end
