(* ========================================================================= *)
(* POINTS ON A GO BOARD                                                      *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Point =
sig

(* ------------------------------------------------------------------------- *)
(* A type of points.                                                         *)
(* ------------------------------------------------------------------------- *)

datatype point = Point of {file : int, rank : int}

val compare : point * point -> order

val equal : point -> point -> bool

val file : point -> int

val rank : point -> int

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val fileToString : int -> string

val rankToString : int -> string

val pp : point Print.pp

val toString : point -> string

val fromString : string -> point

end
