(* ========================================================================= *)
(* GO RULES                                                                  *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Rules =
sig

(* ------------------------------------------------------------------------- *)
(* A type of Go rules.                                                       *)
(* ------------------------------------------------------------------------- *)

datatype rules =
    American
  | Chinese
  | Japanese
  | NewZealand
  | SST

val allRules : rules list

(* ------------------------------------------------------------------------- *)
(* Suicide.                                                                  *)
(* ------------------------------------------------------------------------- *)

val permitSuicide : rules -> bool

(* ------------------------------------------------------------------------- *)
(* Komi.                                                                     *)
(* ------------------------------------------------------------------------- *)

val komi : rules -> {handicap : int} -> Komi.komi

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val toString : rules -> string

val fromString : string -> rules

end
