(* ========================================================================= *)
(* GO SCORES                                                                 *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Score =
sig

(* ------------------------------------------------------------------------- *)
(* A type of go scores.                                                       *)
(* ------------------------------------------------------------------------- *)

datatype score = Win of Side.side * real | Draw

val isWin : score -> Side.side -> bool

val fromPoints : Komi.komi -> int -> score

(* ------------------------------------------------------------------------- *)
(* Parsing and pretty printing.                                              *)
(* ------------------------------------------------------------------------- *)

val toString : score -> string

val fromString : string -> score

end
