(* ========================================================================= *)
(* THE STATUS OF A POINT ON A GO BOARD                                       *)
(* Copyright (c) 2005 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Status =
sig

(* ------------------------------------------------------------------------- *)
(* A type of point statuses.                                                 *)
(* ------------------------------------------------------------------------- *)

datatype status =
    Stone of Side.side
  | Eye of Side.side
  | Seki

val compare : status * status -> order

val allStatuses : status list

val fold : (status * 'a -> 'a) -> 'a -> 'a

val transform : Symmetry.symmetry -> status -> status

(* ------------------------------------------------------------------------- *)
(* Status sides.                                                             *)
(* ------------------------------------------------------------------------- *)

val destStone : status -> Side.side option

val isStone : status -> bool

val destEye : status -> Side.side option

val isEye : status -> bool

val destTerritory : status -> Side.side option

val isTerritory : status -> bool

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : status Print.pp

val toString : status -> string

end
