(* ========================================================================= *)
(* PROFILING INFERENCE COMMANDS                                              *)
(* Copyright (c) 2010 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Inference =
sig

(* ------------------------------------------------------------------------- *)
(* A type of inference command profiles.                                     *)
(* ------------------------------------------------------------------------- *)

type inference

(* ------------------------------------------------------------------------- *)
(* Constructors and destructors.                                             *)
(* ------------------------------------------------------------------------- *)

val empty : inference

val null : inference -> bool

(* ------------------------------------------------------------------------- *)
(* Adding inferences.                                                        *)
(* ------------------------------------------------------------------------- *)

val add : inference -> Command.command -> inference

(* ------------------------------------------------------------------------- *)
(* Merging inference profiles.                                               *)
(* ------------------------------------------------------------------------- *)

val union : inference -> inference -> inference

(* ------------------------------------------------------------------------- *)
(* Pretty-printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : inference Print.pp

end
