(* ========================================================================= *)
(* PACKAGE VERSIONS                                                          *)
(* Copyright (c) 2009 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature PackageVersion =
sig

(* ------------------------------------------------------------------------- *)
(* A type of theory package versions.                                        *)
(* ------------------------------------------------------------------------- *)

type version

(* ------------------------------------------------------------------------- *)
(* Incrementing versions.                                                    *)
(* ------------------------------------------------------------------------- *)

val increment : version -> version

(* ------------------------------------------------------------------------- *)
(* Converting between integer lists.                                         *)
(* ------------------------------------------------------------------------- *)

val toList : version -> int list

val fromList : int list -> version

(* ------------------------------------------------------------------------- *)
(* A total order.                                                            *)
(* ------------------------------------------------------------------------- *)

val compare : version * version -> order

val equal : version -> version -> bool

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : version Print.pp

val toString : version -> string

(* ------------------------------------------------------------------------- *)
(* Parsing.                                                                  *)
(* ------------------------------------------------------------------------- *)

val parser : (char,version) Parse.parser

val fromString : string -> version

end
