(* ========================================================================= *)
(* HIGHER ORDER LOGIC SYMBOLS                                                *)
(* Copyright (c) 2011 Joe Leslie-Hurd, distributed under the MIT license     *)
(* ========================================================================= *)

signature Symbol =
sig

(* ------------------------------------------------------------------------- *)
(* A type of symbols.                                                        *)
(* ------------------------------------------------------------------------- *)

datatype symbol =
    TypeOp of TypeOp.typeOp
  | Const of Const.const

(* ------------------------------------------------------------------------- *)
(* Destructors.                                                              *)
(* ------------------------------------------------------------------------- *)

val name : symbol -> Name.name

val isUndef : symbol -> bool

(* ------------------------------------------------------------------------- *)
(* A total order on symbols.                                                 *)
(* ------------------------------------------------------------------------- *)

val compare : symbol * symbol -> order

val equal : symbol -> symbol -> bool

(* ------------------------------------------------------------------------- *)
(* Primitive symbols.                                                        *)
(* ------------------------------------------------------------------------- *)

val primitives : symbol list

(* ------------------------------------------------------------------------- *)
(* Pretty printing.                                                          *)
(* ------------------------------------------------------------------------- *)

val pp : symbol Print.pp

val toString : symbol -> string

end
